/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.transformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.data.content.ContentSectionList;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.client.screen.book.BookScreen;

public class IndexTransformer
extends BookTransformer {
    public static final IndexTransformer INSTANCE = new IndexTransformer();
    public static final class_2960 INDEX_EXTRA_DATA = Mantle.getResource("index");
    private static final Set<class_2960> hiddenPageTypes = new HashSet<class_2960>();

    private static int ceilingDivide(int value, int divisor) {
        int result = value / divisor;
        if (value % divisor != 0) {
            ++result;
        }
        return result;
    }

    private List<SectionData> getVisibleSections(@Nullable BookScreen.AdvancementCache advancementCache, BookData book) {
        return IndexTransformer.filterHiddenSections(book.getVisibleSections(advancementCache));
    }

    @Override
    public void transform(final BookData book) {
        final int sectionsPerPage = book.appearance.drawFourColumnIndex ? 12 : 9;
        SectionData index = new SectionData(true){

            @Override
            public void update(@Nullable BookScreen.AdvancementCache advancementCache) {
                this.pages.clear();
                List<SectionData> visibleSections = IndexTransformer.this.getVisibleSections(advancementCache, book);
                if (visibleSections.isEmpty()) {
                    return;
                }
                visibleSections.remove(0);
                PageData[] pages = new PageData[IndexTransformer.ceilingDivide(visibleSections.size(), sectionsPerPage)];
                for (int i = 0; i < pages.length; ++i) {
                    int pageStart;
                    pages[i] = new PageData(true);
                    pages[i].name = "page" + (i + 1);
                    ContentSectionList content = new ContentSectionList();
                    pages[i].content = content;
                    for (int j = pageStart = i * sectionsPerPage; j - pageStart < 16 && j < visibleSections.size(); ++j) {
                        content.addSection(visibleSections.get(j));
                    }
                }
                this.pages.addAll(Arrays.asList(pages));
            }
        };
        List<SectionData> visibleSections = this.getVisibleSections(null, book);
        if (!visibleSections.isEmpty()) {
            PageData[] pages = new PageData[IndexTransformer.ceilingDivide(visibleSections.size() - 1, sectionsPerPage)];
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = new PageData(true);
                pages[i].name = "page" + (i + 1);
                pages[i].content = new ContentBlank();
            }
            index.pages.addAll(Arrays.asList(pages));
        }
        index.name = "index";
        book.sections.add(0, index);
    }

    public static boolean isPageHidden(PageData page) {
        JsonElement hidden;
        JsonObject dataObject;
        JsonElement data;
        if (hiddenPageTypes.contains(page.type)) {
            return true;
        }
        if (page.extraData.containsKey(INDEX_EXTRA_DATA) && (data = page.extraData.get(INDEX_EXTRA_DATA)).isJsonObject() && (dataObject = data.getAsJsonObject()).has("hidden") && (hidden = dataObject.get("hidden")).isJsonPrimitive() && hidden.getAsJsonPrimitive().isBoolean()) {
            return hidden.getAsBoolean();
        }
        return false;
    }

    public static boolean isSectionHidden(SectionData section) {
        JsonElement hidden;
        JsonObject dataObject;
        JsonElement data;
        if (section.extraData.containsKey(INDEX_EXTRA_DATA) && (data = section.extraData.get(INDEX_EXTRA_DATA)).isJsonObject() && (dataObject = data.getAsJsonObject()).has("hidden") && (hidden = dataObject.get("hidden")).isJsonPrimitive() && hidden.getAsJsonPrimitive().isBoolean()) {
            return hidden.getAsBoolean();
        }
        return false;
    }

    public static List<PageData> filterHiddenPages(List<PageData> pages) {
        return pages.stream().filter(page -> !IndexTransformer.isPageHidden(page)).collect(Collectors.toList());
    }

    public static List<SectionData> filterHiddenSections(List<SectionData> sections) {
        return sections.stream().filter(section -> !IndexTransformer.isSectionHidden(section)).collect(Collectors.toList());
    }

    public static void addHiddenPageType(class_2960 pageType) {
        hiddenPageTypes.add(pageType);
    }
}

